<?php
session_start();
include "conexao.php";

$mes = $_GET['mes'] ?? date('Y-m');
$id_funcionario = $_SESSION['usuario']['id'];

$stmt1 = $pdo->prepare("SELECT * FROM batidas_afd WHERE pis = (SELECT pis FROM funcionarios WHERE id = ?) AND DATE_FORMAT(data_hora, '%Y-%m') = ?");
$stmt1->execute([$id_funcionario, $mes]);
$afd = $stmt1->fetchAll();

$stmt2 = $pdo->prepare("SELECT * FROM batidas_online WHERE id_funcionario = ? AND DATE_FORMAT(data_hora, '%Y-%m') = ?");
$stmt2->execute([$id_funcionario, $mes]);
$online = $stmt2->fetchAll();

function formatBatidas($batidas) {
    $dias = [];
    foreach ($batidas as $b) {
        $dia = date('Y-m-d', strtotime($b['data_hora']));
        $dias[$dia][] = $b;
    }
    return $dias;
}

$batidas = array_merge($afd, $online);
$batidas_por_dia = formatBatidas($batidas);
?>
<!DOCTYPE html>
<html>
<head><title>Espelho de Ponto</title></head>
<body>
<h2>Espelho de Ponto - <?php echo $mes; ?></h2>
<?php foreach ($batidas_por_dia as $dia => $marcacoes): ?>
    <h4><?php echo $dia; ?></h4>
    <ul>
    <?php foreach ($marcacoes as $m): ?>
        <li><?php echo date('H:i:s', strtotime($m['data_hora'])) . " - " . ($m['tipo'] ?? 'AFD'); ?></li>
    <?php endforeach; ?>
    </ul>
<?php endforeach; ?>
<p><a href="painel.php">Voltar</a></p>
</body>
</html>
