<?php
session_start();
include "conexao.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tipo = $_POST['tipo'];
    $id_funcionario = $_SESSION['usuario']['id'];
    $data_hora = date('Y-m-d H:i:s');
    $foto = $_POST['foto_base64'] ?? '';
    $latitude = $_POST['latitude'] ?? '';
    $longitude = $_POST['longitude'] ?? '';
    $ip = $_SERVER['REMOTE_ADDR'];

    $stmt = $pdo->prepare("INSERT INTO batidas_online (id_funcionario, tipo, data_hora, foto_base64, latitude, longitude, ip_cliente)
                           VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$id_funcionario, $tipo, $data_hora, $foto, $latitude, $longitude, $ip]);
    echo "Ponto registrado com sucesso!";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Registrar Ponto</title>
    <script>
        function registrar(tipo) {
            navigator.geolocation.getCurrentPosition(function(pos) {
                let latitude = pos.coords.latitude;
                let longitude = pos.coords.longitude;
                let fotoInput = document.getElementById('foto');
                let foto = fotoInput.files[0];

                let reader = new FileReader();
                reader.onloadend = function () {
                    let base64foto = reader.result;

                    let form = new FormData();
                    form.append('tipo', tipo);
                    form.append('latitude', latitude);
                    form.append('longitude', longitude);
                    form.append('foto_base64', base64foto);

                    fetch('registrar_ponto.php', { method: 'POST', body: form })
                        .then(res => res.text())
                        .then(alert);
                };
                reader.readAsDataURL(foto);
            });
        }
    </script>
</head>
<body>
<h2>Registrar Ponto</h2>
<p>Escolha uma foto (selfie): <input type="file" id="foto" accept="image/*" capture="user" required></p>
<button onclick="registrar('entrada')">Entrada</button>
<button onclick="registrar('almoco_saida')">Saída para Almoço</button>
<button onclick="registrar('almoco_retorno')">Retorno do Almoço</button>
<button onclick="registrar('saida')">Saída Final</button>
<p><a href="painel.php">Voltar</a></p>
</body>
</html>
